<?php defined('SYSPATH') or die('No direct script access.');

class Task_Serverstats_Update_CountLogpostsSphinx extends Minion_Task
{
    
    const UPDATE_PERIOD = 60;
    
	protected function _execute(array $params)
    {
        Task_Helper::createWorker('Serverstats:Update:CountLogpostsSphinx', $this);
	}

    public function Worker(GearmanJob $job)
    {
        $serverstat = ORM::factory('Serverstat', 'CountLogpostsSphinx');
        
        if ( null !== $serverstat->updated_at && time() - strtotime($serverstat->updated_at) <= self::UPDATE_PERIOD )
        {
            return;
        }
        
        /**
         * Update server stat "CountLogpostsSphinx"
         */
        $logpostTotalInfo = $this->getLogpostTotalInfo();
        $countLogpostsSphinx = $logpostTotalInfo['total_found'];
        if (0 == $countLogpostsSphinx) {
            $countLogpostsSphinx = '<span class="text-danger">' . $countLogpostsSphinx . '</span>';
        }

        Model_Serverstat::setStat('CountLogpostsSphinx', $countLogpostsSphinx);

        /**
         * Update server stat "DistributedServerStats"
         */
        if ( isset($logpostTotalInfo['warning']) )
        {
            $logpostTotalInfoWarnings = explode(';', '<span class="text-danger">' . $logpostTotalInfo['warning'] . '</span>');
        }
        else
        {
            $logpostTotalInfoWarnings = array('<span class="text-success">OK</span>');
        }
        Model_Serverstat::setStat('DistributedServerStats', implode('<br />', $logpostTotalInfoWarnings));
    }
    
    protected function getLogpostTotalInfo()
    {
        $sphinxql = new SphinxQL();
        $result = $sphinxql->new_query()
            ->add_index('logpost')
            ->limit(0)
            ->executeOrFail();
        
        return $result['total_info'];
    }
    
}